package edu.unl.consystlab.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class GrapherComponent extends Component implements Runnable
{
   
    private int[] values;
    private Graphable g;
    private int f=0;
    private int msec=100;
    private boolean partial = true;
    private Thread t;
    private int min=0, max = 0;
    
    public GrapherComponent(Graphable g, int num, int msec)
    {
        this.g = g;
        values = new int[num];
        this.msec = msec;
        t = new Thread(this);
        t.start();
    }

    public void run()
    {
        for(;;)
        {
            try { Thread.sleep(msec); } catch(Exception e) {} 
            int t = values[f++] = g.getValue();
            if(t<min) min=t*2;
            if(t>max) max=t*2;
            if(f==values.length)
            {
                f = 0;
                partial = false;
            }
            repaint();
        }
    }
    

    public void paint(Graphics g, int value, int pos, int mh, int mw, int middle, int scale)
    {
        int x = (mw * pos)/values.length;
        int dy = (value * mh)/scale;
        dy=dy * -1;
        // g.fillArc(y,x,3,3,0,360);
        int w = mw/values.length;

        //g.fillRect(x,h-y,w,y);
        
        if(dy<0)
           g.fillRect(x,middle+dy,w,-dy);
        else
            g.fillRect(x,middle+1,w,dy);
    }
    
    public void paint(Graphics g)
    {
        int h = this.getHeight();
        int w = this.getWidth();

        //g.setColor(Color.green);
        //g.fillRect(10,20,30,40);

        int middle=0, scale=1;
        
        if(max>=0 && min>=0) // only positive numbers
        {
            scale = max;
            middle = h;
        }
        if(max<=0 && min<=0) // only negative input
        {
            scale = Math.abs(min);
            middle = 0;
        }
        if(max>=0 && min<0) // some above zero, others below
        {
           scale=max - min;
           middle = h - (max * h)/(scale==0?1:scale);
        }
        g.setColor(Color.red);
        //System.out.println("min="+min+", max="+max+", h="+h+", middle="+middle+", w="+w+", scale="+scale);       
        g.drawLine(0,middle,w,middle);
        g.setColor(Color.blue);
        //System.out.println("\ni\tf\tPos\tValue\n");
        int pos=0;
        if(partial) // only 0..f of values[] has been measured
        {
            for(int i=0; i<f; i++)
            {
                //System.out.println(i+"\t"+f+"\t"+(i)+"\t"+values[i]);
                paint(g,values[i],pos++,h,w,middle,scale);
            }
        }
        else
        {
            
            for(int i=f; i<values.length; i++)
            {
                //System.out.println(i+"\t"+f+"\t"+(pos)+"\t"+values[i]);
                paint(g,values[i],pos++,h,w,middle,scale);
            }
            for(int i=0; i<f; i++)
            {
                //System.out.println(i+"\t"+f+"\t"+(pos)+"\t"+values[i]);
                paint(g,values[i],pos++,h,w,middle,scale);
            }
        }
        
    }
  
    

}
